<!-- Page Breadcrumb -->
                <div class="page-breadcrumbs">
                    <ul class="breadcrumb">
                        <li>
                            <i class="fa fa-home"></i>
                            <a href="#">Home</a>
                        </li>
                        <li class="active">Recharge</li>
                    </ul>
                </div>
                <!-- /Page Breadcrumb -->
                <!-- Page Header -->
                <div class="page-header position-relative">

                    <!--Header Buttons-->
                    <div class="header-buttons">
                        <a class="sidebar-toggler" href="#">
                            <i class="fa fa-arrows-h"></i>
                        </a>
                        <a class="refresh" id="refresh-toggler" href="#">
                            <i class="glyphicon glyphicon-refresh"></i>
                        </a>
                        <a class="fullscreen" id="fullscreen-toggler" href="#">
                            <i class="glyphicon glyphicon-fullscreen"></i>
                        </a>
                    </div>
                    <!--Header Buttons End-->
                </div>


<div class="page-body">
<div class="container">
    <?php if ($this->session->flashdata('success_message')): ?>
        <div class="alert alert-success">
            <?php echo $this->session->flashdata('success_message'); ?>
        </div>
    <?php elseif ($this->session->flashdata('error_message')): ?>
        <div class="alert alert-danger">
            <?php echo $this->session->flashdata('error_message'); ?>
        </div>
    <?php endif; ?>
</div>  

<div class="container">
    <div class="form-container col-md-6">
        <?php echo form_open('recharge/credits', array('id' => 'recharge_form')); ?>


<div class="form-group">
    <label for="account_label">Select Account:</label>
    <input type="text" id="search_account" class="form-control" placeholder="Search..." autocomplete="off">
    <select class="form-control d-none" name="account_label" id="account_label">
        <option value="">Select an account</option>
        <?php foreach ($sub_accounts as $account): ?>
            <option value="<?php echo $account->account_code; ?>" data-number="<?php echo $account->number; ?>">
                <?php echo $account->number; ?>
            </option>
        <?php endforeach; ?>
    </select>
    <input type="hidden" name="account_number" id="account_number" value="">
    <div id="dropdown_list" class="dropdown-list form-control" style="display: none;"></div>
</div>

<div class="form-group">
    <label for="recharge_value">Value (0 to 15 digits):</label>
    <input type="number" class="form-control" name="recharge_value" id="recharge_value" min="0" max="999999999999999" required>
</div>

<div class="form-group">
    <input type="submit" class="btn btn-primary" value="Recharge">
</div>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const searchInput = document.getElementById("search_account");
    const selectElement = document.getElementById("account_label");
    const dropdownList = document.getElementById("dropdown_list");
    const hiddenInput = document.getElementById("account_number");

    const originalOptions = Array.from(selectElement.options);

    function filterOptions(query) {
        const filtered = originalOptions.filter(option => 
            option.text.toLowerCase().includes(query.toLowerCase())
        );
        updateDropdown(filtered);
    }

    function updateDropdown(options) {
        dropdownList.innerHTML = ""; // Clear existing results
        if (options.length === 0) {
            const noMatch = document.createElement("div");
            noMatch.className = "dropdown-item";
            noMatch.textContent = "No matching accounts found.";
            dropdownList.appendChild(noMatch);
            dropdownList.style.display = "block";
            return;
        }
        options.forEach(option => {
            if (!option.value) return; // Skip empty options
            const item = document.createElement("div");
            item.className = "dropdown-item";
            item.textContent = option.text;
            item.setAttribute("data-value", option.value);
            item.setAttribute("data-number", option.getAttribute("data-number"));
            item.addEventListener("click", function () {
                searchInput.value = option.text;
                selectElement.value = option.value;
                hiddenInput.value = option.getAttribute("data-number");
                dropdownList.style.display = "none";
            });
            dropdownList.appendChild(item);
        });
        dropdownList.style.display = "block";
    }

    searchInput.addEventListener("input", function () {
        const query = this.value;
        filterOptions(query);
    });

    searchInput.addEventListener("focus", function () {
        const query = this.value;
        filterOptions(query);
    });

    document.addEventListener("click", function (event) {
        if (!searchInput.contains(event.target) && !dropdownList.contains(event.target)) {
            dropdownList.style.display = "none";
        }
    });
});
</script>

<style>
.dropdown-list {
    position: absolute;
    z-index: 1000;
    background: white;
    border: 1px solid #ccc;
    /* max-height: 200px; */
    min-height: 250px;
    overflow-y: auto;
}

.dropdown-item {
    padding: 8px;
    cursor: pointer;
}

.dropdown-item:hover {
    background: #f0f0f0;
}

.d-none {
    display: none;
}
</style>

<!-- Include Select2 CSS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />

<!-- Include Select2 JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>


    <!--Basic Scripts-->
    <script src="<?php echo base_url(); ?>assets/js/jquery-2.0.3.min.js"></script>
    <script src="<?php echo base_url(); ?>assets/js/bootstrap.min.js"></script>

    <!--Beyond Scripts-->
    <script src="<?php echo base_url(); ?>assets/js/beyond.min.js"></script>


    <!--Page Related Scripts-->
    <!--Sparkline Charts Needed Scripts-->
    <script src="<?php echo base_url(); ?>assets/js/charts/sparkline/jquery.sparkline.js"></script>
    <script src="<?php echo base_url(); ?>assets/js/charts/sparkline/sparkline-init.js"></script>

    <!--Easy Pie Charts Needed Scripts-->
    <script src="<?php echo base_url(); ?>assets/js/charts/easypiechart/jquery.easypiechart.js"></script>
    <script src="<?php echo base_url(); ?>assets/js/charts/easypiechart/easypiechart-init.js"></script>

    <!--Flot Charts Needed Scripts-->
    <script src="<?php echo base_url(); ?>assets/js/charts/flot/jquery.flot.js"></script>
    <script src="<?php echo base_url(); ?>assets/js/charts/flot/jquery.flot.resize.js"></script>
    <script src="<?php echo base_url(); ?>assets/js/charts/flot/jquery.flot.pie.js"></script>
    <script src="<?php echo base_url(); ?>assets/js/charts/flot/jquery.flot.tooltip.js"></script>
    <script src="<?php echo base_url(); ?>assets/js/charts/flot/jquery.flot.orderBars.js"></script>
<!-- Include the necessary CSS and JS for Select2 
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
-->
<script>
document.getElementById('account_label').addEventListener('change', function() {
    var selectedOption = this.options[this.selectedIndex];
    var accountNumber = selectedOption.getAttribute('data-number');
    document.getElementById('account_number').value = accountNumber;
});

</script>




	</div>
	</div>
	
<?php 
define('BASE_PATH', '/var/www/html/iptm/application/views');
include BASE_PATH . '/partial/dev_footer.php';
?>

</body>

</html>

		<?php
			// echo "MASHUD";
	// exit();
	?> 
	
