<?php 
  
    $defaultStartDatetime = isset($_POST['startDatetime']) ? $_POST['startDatetime'] : date('Y-m-d') . ' 00:00:01';
    $defaultEndDatetime = isset($_POST['endDatetime']) ? $_POST['endDatetime'] : date('Y-m-d') . ' 23:59:59';
?>

    <div class="page-breadcrumbs">
        <ul class="breadcrumb">
            <li>
                <i class="fa fa-home"></i>
                <a href="#">Home</a>
            </li>
            <li>
                <a href="#">Call Logs</a>
            </li>

        </ul>
    </div>

    <div class="page-header position-relative">
        <div class="header-title">
            <h1> 
                                Call Logs
                        </h1>
        </div>

        <div class="header-buttons">
            <a class="sidebar-toggler" href="#">
                <i class="fa fa-arrows-h"></i>
            </a>
            <a class="refresh" id="refresh-toggler" href="#">
                <i class="glyphicon glyphicon-refresh"></i>
            </a>
            <a class="fullscreen" id="fullscreen-toggler" href="#">
                <i class="glyphicon glyphicon-fullscreen"></i>
            </a>
        </div>

    </div>

    <div class="page-body">
        <div class="row">

            </br>
            <div class="col-xs-12 col-md-12">
			<!--
                <div class="clearfix">
                    <form action="" method="POST" style="display: flex; align-items: center; gap: 20px; flex-wrap: wrap;">
						<div>
							<label for="accountCode">Account Code:</label>
							<br>
							<input type="text" id="accountCode" name="accountCode" placeholder="Enter Account Code">
						</div>
                        <div>
                            <label for="fromNumber">From Number:</label>
                            <br>
                            <input type="text" id="fromNumber" name="fromNumber" placeholder="Enter From Number" >
                        </div>
                        <div>
                            <label for="toNumber">To Number:</label>
                            <br>
                            <input type="text" id="toNumber" name="toNumber" placeholder="Enter To Number" >
                        </div>
                        <div>
                            <label for="startDatetime">Start Datetime:</label>
                            <br>
                            <input type="datetime-local" id="startDatetime" name="startDatetime" required>
                        </div>
                        <div>
                            <label for="endDatetime">End Datetime:</label>
                            <br>
                            <input type="datetime-local" id="endDatetime" name="endDatetime" required>
                        </div>
                        <div>
                            <input class="btn btn-warning shiny" type="submit" value="Search" style="margin-top: 24px;">
                        </div>
						
					
											
                    </form>

                </div>
				
				-->

<!-- Flatpickr CSS -->
<link rel="stylesheet" href="<?php echo base_url(); ?>assets/css/flatpickr.min.css">

<!-- Flatpickr JS 
<script src="<?php echo base_url(); ?>assets/js/flatpickr"></script>
-->
<script src="<?php echo base_url(); ?>assets/js/flatpickr.js"></script>
<div class="clearfix">
    <form id="searchForm" method="POST" 
      style="padding: 20px; background-color: #f9f9f9; border-radius: 10px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); max-width: 900px; margin: auto;">
    <div style="display: flex; flex-wrap: wrap; gap: 20px;">
        <!-- Account Code -->
        <div style="flex: 1; min-width: 250px;">
            <label for="accountCode" style="font-weight: bold;">Account Code:</label>
            <br>
            <input type="text" id="accountCode" name="accountCode" 
                   placeholder="Enter Account Code" 
                   value="<?php echo isset($_POST['accountCode']) ? $_POST['accountCode'] : ''; ?>"
                   style="width: 100%; padding: 10px; border-radius: 5px; border: 1px solid #ddd;">
        </div>

        <!-- From Number -->
        <div style="flex: 1; min-width: 250px;">
            <label for="fromNumber" style="font-weight: bold;">From Number:</label>
            <br>
            <input type="text" id="fromNumber" name="fromNumber" 
                   placeholder="Enter From Number" 
                   value="<?php echo isset($_POST['fromNumber']) ? $_POST['fromNumber'] : ''; ?>"
                   style="width: 100%; padding: 10px; border-radius: 5px; border: 1px solid #ddd;">
        </div>

        <!-- To Number -->
        <div style="flex: 1; min-width: 250px;">
            <label for="toNumber" style="font-weight: bold;">To Number:</label>
            <br>
            <input type="text" id="toNumber" name="toNumber" 
                   placeholder="Enter To Number" 
                   value="<?php echo isset($_POST['toNumber']) ? $_POST['toNumber'] : ''; ?>"
                   style="width: 100%; padding: 10px; border-radius: 5px; border: 1px solid #ddd;">
        </div>

        <!-- Start Datetime -->
        <div style="flex: 1; min-width: 250px;">
            <label for="startDatetime" style="font-weight: bold;">Start Datetime:</label>
            <br>
            <input type="text" id="startDatetime" name="startDatetime" 
                   placeholder="Select Start Datetime" 
                   value="<?php echo isset($_POST['startDatetime']) ? $_POST['startDatetime'] : $defaultStartDatetime; ?>"
                   style="width: 100%; padding: 10px; border-radius: 5px; border: 1px solid #ddd;">
        </div>

        <!-- End Datetime -->
        <div style="flex: 1; min-width: 250px;">
            <label for="endDatetime" style="font-weight: bold;">End Datetime:</label>
            <br>
            <input type="text" id="endDatetime" name="endDatetime" 
                   placeholder="Select End Datetime" 
                   value="<?php echo isset($_POST['endDatetime']) ? $_POST['endDatetime'] : $defaultEndDatetime; ?>"
                   style="width: 100%; padding: 10px; border-radius: 5px; border: 1px solid #ddd;">
        </div>
    </div>

    <!-- Submit Button -->
    <div style="text-align: center; margin-top: 20px;">
        <input class="btn btn-warning shiny" type="submit" value="🔍 Search" 
               style="padding: 15px 40px; border: none; border-radius: 50px; background: linear-gradient(90deg, #ff7e5f, #feb47b); 
                      color: white; font-size: 16px; font-weight: bold; cursor: pointer; box-shadow: 0 4px 6px rgba(0, 0, 0, 0.2); 
                      transition: all 0.3s ease-in-out;">
    </div>
</form>
</div>

<br>

<div class="well">
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/datatables/dataTables.bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/datatables/buttons.bootstrap.min.css">

    <table id="example" class="table table-bordered" cellspacing="0" width="100%">
        <thead>
            <tr>
                <th>Call Start</th>
                <th>Call End</th>
                <th>Caller</th>
                <th>Destination</th>
                <th>Duration(Sec)</th>
                <th>Cost (BDT)</th>
                <th>Status</th>
                <th>Account Code</th>
                <th>Call Type</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>

<script>
   $(document).ready(function () {
 
    var defaultStartDatetime = new Date();
    defaultStartDatetime.setHours(0, 0, 1);

    if (!$('#startDatetime').val()) {
        $('#startDatetime').val(defaultStartDatetime.toISOString().slice(0, 19).replace('T', ' '));  // Format to 'YYYY-MM-DD HH:mm:ss'
    }

    var table = $('#example').DataTable({
        processing: true,
        serverSide: false,
       // serverSide: true,
        ajax: {
            url: "<?php echo base_url('index.php/call_logs/fetch_call_logs'); ?>",
            type: "POST",
            dataType: "json",
            contentType: "application/x-www-form-urlencoded",
            data: function (d) {
           
                if ($('#fromNumber').val()) {
                    d.fromNumber = $('#fromNumber').val();
                }
                if ($('#toNumber').val()) {
                    d.toNumber = $('#toNumber').val();
                }
                if ($('#accountCode').val()) {
                    d.accountCode = $('#accountCode').val();
                }
                if ($('#startDatetime').val()) {
                    d.startDatetime = $('#startDatetime').val();
                }
                if ($('#endDatetime').val()) {
                    d.endDatetime = $('#endDatetime').val();
                }
            },
            error: function (xhr, error, thrown) {
                console.log("AJAX Error:", xhr.responseText);
            }
        },
        columns: [
            { data: "starttime" },
            { data: "stoptime" },
            { data: "src" },
            { data: "calledstation" },
            { data: "duration" },
            { data: "call_cost" },
            { 
                data: "terminatecauseid",
                render: function (data) {
                    switch (data) {
                        case "1": return "ANSWER";
                        case "2": return "BUSY";
                        case "3": return "NOANSWER";
                        case "4": return "CANCEL";
                        case "5": return "CONGESTION";
                        case "6": return "CHANUNAVAIL";
                        default: return "UNKNOWN";
                    }
                }
            },
            { data: "accountcode" },
            { data: "call_direction" }
        ],
      responsive: true,
    paging: true,
    searching: true, 
    ordering: true,
    info: true,
    pageLength: 10, 
    lengthMenu: [10, 25, 50, 100, 500], 
    dom: 'Bfrtip', // Define the layout of the DataTable
        // buttons: [
            // { extend: 'csv', text: 'Export CSV', className: 'btn btn-success', filename: 'red_data_cdr_' + formatDateForFileName() },
            // { extend: 'excel', text: 'Export Excel', className: 'btn btn-primary', filename: 'red_data_cdr_' + formatDateForFileName() },
            // { extend: 'print', text: 'Print', className: 'btn btn-info', filename: 'red_data_cdr_' + formatDateForFileName() }
        // ]
		
		buttons: [
        {
            extend: 'csv',
            text: 'Export CSV',
            className: 'btn btn-success',
            filename: 'red_data_cdr_' + formatDateForFileName(),
            action: function (e, dt, node, config) {
                // Trigger server-side export for CSV
                window.location.href = "<?php echo base_url('index.php/call_logs/export_csv'); ?>?fromNumber=" + $('#fromNumber').val() + "&toNumber=" + $('#toNumber').val() + "&accountCode=" + $('#accountCode').val() + "&startDatetime=" + $('#startDatetime').val() + "&endDatetime=" + $('#endDatetime').val();
            }
        },
        {
            extend: 'excel',
            text: 'Export Excel',
            className: 'btn btn-primary',
            filename: 'red_data_cdr_' + formatDateForFileName(),
            action: function (e, dt, node, config) {
                // Trigger server-side export for Excel
                window.location.href = "<?php echo base_url('index.php/call_logs/export_excel'); ?>?fromNumber=" + $('#fromNumber').val() + "&toNumber=" + $('#toNumber').val() + "&accountCode=" + $('#accountCode').val() + "&startDatetime=" + $('#startDatetime').val() + "&endDatetime=" + $('#endDatetime').val();
            }
        },
        {
            extend: 'print',
            text: 'Print',
            className: 'btn btn-info',
            filename: 'red_data_cdr_' + formatDateForFileName(),
            action: function (e, dt, node, config) {
                // Trigger print functionality (for the current page)
                dt.buttons.exportData({
                    modifier: {
                        selected: null
                    }
                });
            }
        }
    ]
    });
	
	function formatDateForFileName() {
    var now = new Date();
    var year = now.getFullYear();
    var month = String(now.getMonth() + 1).padStart(2, '0');
    var day = String(now.getDate()).padStart(2, '0');
    var hours = String(now.getHours()).padStart(2, '0');
    var minutes = String(now.getMinutes()).padStart(2, '0');
    var seconds = String(now.getSeconds()).padStart(2, '0');

    return year + '_' + month + '_' + day + '_' + hours + '_' + minutes + '_' + seconds;
}

    // Reload table data when form is submitted
    $('#searchForm').on('submit', function(e) {
        e.preventDefault(); // Prevent form submission
        table.ajax.reload(null, false);  // Reload table without resetting pagination
    });
});

</script>

</div>


            </div>
            </br>
            </br>
            </br>

            <div class="col-xs-12 col-md-12 hidden">
                <?php foreach($css_files as $file): ?>
                    <link type="text/css" rel="stylesheet" href="<?php echo $file; ?>" />

                    <?php endforeach; ?>
                        <?php foreach($js_files as $file): ?>

                            <script src="<?php echo $file; ?>"></script>
                            <?php endforeach; ?>
                                <?php echo $output; ?>
            </div>
        </div>



    </div>
    <script src="<?php echo base_url(); ?>assets/js/jquery-2.0.3.min.js"></script>
    <script src="<?php echo base_url(); ?>assets/datatables/jquery.dataTables.min.js"></script>
    <script src="<?php echo base_url(); ?>assets/datatables/dataTables.bootstrap.min.js"></script>


    <script src="<?php echo base_url();?>assets/datatables/dataTables.buttons.min.js"></script>
    <script src="<?php echo base_url();?>assets/datatables/buttons.colVis.min.js"></script>
    <script src="<?php echo base_url();?>assets/datatables/buttons.html5.min.js"></script>
    <script src="<?php echo base_url();?>assets/datatables/buttons.print.min.js"></script>

    <script src="<?php echo base_url();?>assets/datatables/buttons.bootstrap.min.js"></script>
    <script src="<?php echo base_url();?>assets/datatables/jszip.min.js"></script>
    <script src="<?php echo base_url();?>assets/datatables/vfs_fonts.js"></script>
    <script src="<?php echo base_url();?>assets/datatables/pdfmake.min.js"></script>
    <!--<script src="<?php echo base_url();?>assets/datatables/bootstrap.min.js"></script>-->
    <!--Basic Scripts-->
    <!--<script src="<?php echo base_url(); ?>assets/js/jquery-2.0.3.min.js"></script>-->
    <script src="<?php echo base_url(); ?>assets/js/bootstrap.min.js"></script>
    <!--Beyond Scripts-->
    <script src="<?php echo base_url(); ?>assets/js/beyond.min.js"></script>
    <!--Page Related Scripts-->
    <!--Sparkline Charts Needed Scripts-->
    <script src="<?php echo base_url(); ?>assets/js/charts/sparkline/jquery.sparkline.js"></script>
    <script src="<?php echo base_url(); ?>assets/js/charts/sparkline/sparkline-init.js"></script>
    <!--Easy Pie Charts Needed Scripts-->
    <script src="<?php echo base_url(); ?>assets/js/charts/easypiechart/jquery.easypiechart.js"></script>
    <script src="<?php echo base_url(); ?>assets/js/charts/easypiechart/easypiechart-init.js"></script>
    <!--Flot Charts Needed Scripts-->
    <script src="<?php echo base_url(); ?>assets/js/charts/flot/jquery.flot.js"></script>
    <script src="<?php echo base_url(); ?>assets/js/charts/flot/jquery.flot.resize.js"></script>
    <script src="<?php echo base_url(); ?>assets/js/charts/flot/jquery.flot.pie.js"></script>
    <script src="<?php echo base_url(); ?>assets/js/charts/flot/jquery.flot.tooltip.js"></script>
    <script src="<?php echo base_url(); ?>assets/js/charts/flot/jquery.flot.orderBars.js"></script>



    <script>
        // $(document).ready(function () {
            // $('#example').DataTable({
                // dom: 'Bfrtip', // Define where buttons appear (B = buttons)
                // buttons: [
                    // {
                        // extend: 'csv',
                        // text: 'Export CSV'
                    // },
                    // {
                        // extend: 'excel',
                        // text: 'Export Excel'
                    // },
                    // // {
                        // // extend: 'pdf',
                        // // text: 'Export PDF'
                    // // },
                    // {
                        // extend: 'print',
                        // text: 'Print'
                    // }
                // ],
                // responsive: true,
                // paging: true,
                // searching: true,
                // ordering: true,
                // info: true
            // });
        // });
    </script>
    <style>
        /* Remove the search icon */
        #example_filter.dataTables_filter label:before {
            display:none!important
        }
    </style>

    <script>
        InitiateSimpleDataTable.init();
        InitiateEditableDataTable.init();
        InitiateExpandableDataTable.init();
        InitiateSearchableDataTable.init();
    </script>
<script>
      flatpickr("#startDatetime", {
        enableTime: true,
        dateFormat: "Y-m-d H:i",
        altInput: true,
        altFormat: "F j, Y h:i K", 
    });

   
    flatpickr("#endDatetime", {
        enableTime: true,
        dateFormat: "Y-m-d H:i",
        altInput: true,
        altFormat: "F j, Y h:i K",
        defaultDate: new Date(),
    });
</script>

    <?php include 'partial/dev_footer.php';?>

        <script type="text/javascript">
            $(function() {
            
              $('input[name="datefilter1"]').daterangepicker({
            	  singleDatePicker: true,
                  autoUpdateInput: false,
                  locale: {
                      cancelLabel: 'Clear'
                  }
              });
              
              
              $('input[name="datefilter2"]').daterangepicker({
            	  singleDatePicker: true,
                  autoUpdateInput: false,
                  locale: {
                      cancelLabel: 'Clear'
                  }
              });
            
              /* $('input[name="datefilter"]').on('apply.daterangepicker', function(ev, picker) {
                  $(this).val(picker.startDate.format('YYYY/MM/DD') + ' - ' + picker.endDate.format('YYYY/MM/DD'));
              }); */
              
               $('input[name="datefilter1"]').on('apply.daterangepicker', function(ev, picker) {
                  $(this).val(picker.startDate.format('YYYY-MM-DD'));
              });
              
                 $('input[name="datefilter2"]').on('apply.daterangepicker', function(ev, picker) {
                  $(this).val(picker.endDate.format('YYYY-MM-DD'));
              });
              
              
             /*   $('input[name="datefilter1"]').on('apply.daterangepicker', function(ev, picker) {
                  $(this).val( "'" + picker.startDate.format('YYYY-MM-DD') + "'");
              });
              
                 $('input[name="datefilter2"]').on('apply.daterangepicker', function(ev, picker) {
                  $(this).val( "'" + picker.endDate.format('YYYY-MM-DD') + "'");
              });
             */
              
            
              $('input[name="datefilter"]').on('cancel.daterangepicker', function(ev, picker) {
                  $(this).val('');
              });
            
            });
        </script>
<style>
    /* Add hover and focus effects */
    .btn.btn-warning.shiny:hover {
        background: linear-gradient(90deg, #feb47b, #ff7e5f); /* Reverse gradient */
        box-shadow: 0 8px 12px rgba(0, 0, 0, 0.3);
        transform: translateY(-3px);
        transition: all 0.3s ease-in-out;
    }

    /* Add focus effects for inputs */
    input[type="text"]:focus {
        outline: none;
        border-color: #ff7e5f;
        box-shadow: 0 0 5px rgba(255, 126, 95, 0.8);
    }

    /* Ensure responsive alignment */
    @media (max-width: 768px) {
        form div {
            flex: 1 1 100%; /* Ensure inputs stack on smaller screens */
        }
    }
</style>


        </body>


        </html>