<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
session_start(); //we need to call PHP's session object to access it through CI
class Service_order extends CI_Controller {

 function __construct()
 {
   parent::__construct();
   $this->load->model('user'); // Load the User model
 }

 function index()

   {
     if($this->session->userdata('logged_in')){
     $session_data = $this->session->userdata('logged_in');
     $data['username'] = $session_data['username'];
	 $data['email'] = $session_data['email'];
	 $data['first_name'] = $session_data['first_name'];
	 $data['last_name'] = $session_data['last_name'];
	 	 $data['pic'] = $session_data['pic'];
	$crud = new grocery_CRUD();
	$crud->set_theme('flexigrid');
    $crud->set_table('service_order')
		->set_subject('Service Order');
		
		$all = $this->session->userdata('logged_in');
		//print_r ($all);
		
		$user_id = $all['id'];
		
		if ($user_id == 9){
			//$crud->unset_delete();
		}else{
			$crud->unset_delete();
		}
	
	$crud->set_relation('client_name','customers','name');
	

$crud->callback_before_insert(array($this, 'calculate_total_mrc'));
$crud->callback_before_update(array($this, 'calculate_total_mrc'));

$crud->callback_before_insert(array($this, 'update_zone_based_on_district'));
$crud->callback_before_update(array($this, 'update_zone_based_on_district'));

	//$crud->set_relation_n_n('DID', 'nu_so', 'number_plan', 'nu_id', 'so_id', 'number');
	$crud->display_as('server_maint_charge','Service MRC');
	$crud->display_as('hardware_otc','Hardware OTC');
	$crud->display_as('OTC','Software OTC');
	$crud->display_as('solution_type','Solution Type');
	$crud->display_as('kam','KAM');
	$crud->display_as('channel_mrc','Channel MRC');
	$crud->display_as('MRC','Total MRC');
	$crud->display_as('credit_limit','Credit Limit');
	$crud->display_as('client_id','Client Account Code');
	$crud->display_as('tki_id','Ticket No.');
	$crud->display_as('hosted_server_mrc','Hosted Server MRC');
	$crud->display_as('assigned_data_bw','Assigned Data BW');
	$crud->display_as('data_conn_mrc','Data Connection MRC');
    
	$crud->set_relation_n_n('solution_type', 'ci_sol', 'solution_type', 'solution_id', 'sol_id',  'solution_type');
	
	//MRC = server_maint_charge + channel_mrc + hosted_server_mrc + data_conn_mrc
	
	$crud->field_type('customer_type','enum',array('Corporate','Individual'));
	$crud->field_type('subscription_type','enum',array('Postpaid','Prepaid','Demo','Complementary'));
	$crud->set_relation('district', 'zone_list', 'district');
	$crud->field_type('zone','enum',array('Central Zone','North - East','North - West','South - East','South - West'));
	$crud->field_type('access_engineer','enum',array('Md. Amirul Islam','Support Engineer'));
	$crud->field_type('bill_date','enum',array('1','2','3','4','5','6','7','8','9','10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','25','26','27','28','29','30'));
	$crud->callback_column('domestic_rate',array($this,'valueToTaka'));
	$crud->callback_column('domestic_pulse',array($this,'valueToSec'));
	$crud->callback_column('international_pulse',array($this,'valueToSec'));
	// $crud->required_fields('service_order_no');
	$crud->required_fields('service_order_no','client_id', 'client_site_name','customer_type','subscription_type','bill_from','status');
	
	$crud->field_type('id_client', 'hidden');


	$crud->set_field_upload('job_done_report','assets/uploads/files');
	//$crud->field_type('status','enum',array('Active','Locked','Temporary Stopped','Terminate'));
	//$crud->unset_add();
	
	/*
	$crud->columns(array('client_name','customer_type','solution_type','DID','channel','credit_limit','status','client_site_name','site_address','service_order_date','subscription_type','commission_date'));
	*/
	
	$crud->columns(array('client_name','client_site_name','client_id','solution_type','DID','channel','credit_limit','customer_type','subscription_type','commission_date','status'));
	
	
    $crud->fields(array('client_name','client_site_name','tki_id','client_id','solution_type','service_order_date','target_date','customer_type','subscription_type','site_address','billing_address','district','zone','hardware_otc','OTC','server_maint_charge','channel_mrc','hosted_server_mrc','assigned_data_bw','data_conn_mrc','MRC','credit_limit','DID','number_quantity','channel','domestic_rate','domestic_pulse','international_pulse','call_type','bill_date','id_client','bill_from','access_engineer','commission_date','subscription_form','job_done_report','status','SIP','kam','remark','client_name_bill'));
	
	$crud->set_field_upload('subscription_form','assets/uploads/files');

	
	$output = $crud->render();
  	$this->load->view('partial/header',$data);
	$this->load->view('service_order', $output);
	
	// history insert start-----
	
	if ($_SERVER['REQUEST_METHOD'] === 'GET') {
            // Your logic to handle read operation
            // ...
				$uri_segments = $this->uri->segment_array();

				if (in_array('success', $uri_segments)) {
							
					  // Assuming you have obtained the previous data before the update
				$previous_data = $this->user->get_user_data_by_id($uri_segments[4]);

                // Trigger the callback after a successful edit/update operation
                $this->insert_history('edit/update', 'service_order', $previous_data);
				} 
        } 
	
  } else{redirect('login', 'refresh');}
   }

// Callback function to insert data and user session into the "history" table
    private function insert_history($action, $table_name, $previous_data) {
        $session_data = $this->session->userdata('logged_in');

        $history_data = array(
            'action' => $action,
            'table_name' => $table_name,
            'data' => json_encode($previous_data),
            'username' => $session_data['username'],
            'email' => $session_data['email'],
            'first_name' => $session_data['first_name'],
            'last_name' => $session_data['last_name'],
            'pic' => $session_data['pic']
        );

        $this->user->insert_history_data($history_data);
	//history insert end------
	}
	
public function calculate_total_mrc($post_array)
{
    // Ensure all fields have numeric values
	if (empty($post_array['server_maint_charge'])) {
    $post_array['server_maint_charge'] = 0;
	}
	if (empty($post_array['channel_mrc'])) {
    $post_array['channel_mrc'] = 0;
	}
	if (empty($post_array['hosted_server_mrc'])) {
    $post_array['hosted_server_mrc'] = 0;
	}
	if (empty($post_array['data_conn_mrc'])) {
    $post_array['data_conn_mrc'] = 0;
	}
	
	if (empty($post_array['hardware_otc'])) {
    $post_array['hardware_otc'] = 0;
	}
	
	if (empty($post_array['OTC'])) {
    $post_array['OTC'] = 0;
	}
	
	if (empty($post_array['assigned_data_bw'])) {
    $post_array['assigned_data_bw'] = 0;
	}


    $server_maint_charge = isset($post_array['server_maint_charge']) ? floatval($post_array['server_maint_charge']) : 0;
	print_r($server_maint_charge);
    $channel_mrc = isset($post_array['channel_mrc']) ? floatval($post_array['channel_mrc']) : 0;
    $hosted_server_mrc = isset($post_array['hosted_server_mrc']) ? floatval($post_array['hosted_server_mrc']) : 0;
    $data_conn_mrc = isset($post_array['data_conn_mrc']) ? floatval($post_array['data_conn_mrc']) : 0;

    // Calculate Total MRC
    $post_array['MRC'] = $server_maint_charge + $channel_mrc + $hosted_server_mrc + $data_conn_mrc;

    return $post_array;
}



public function update_zone_based_on_district($post_array) {
    if (!empty($post_array['district'])) {
        
$this->db->select('zone');
$this->db->where('id', $post_array['district']);
$query = $this->db->get('zone_list');
//error_log("SQL Query: " . $this->db->last_query());


        if ($query->num_rows() > 0) {
            $result = $query->row();
            $post_array['zone'] = $result->zone; 
        } else {
            $post_array['zone'] = NULL; 
        }
    }

    return $post_array;
	

}

	
   function valueToTaka($value, $row)
{
    return $value.' Tk';
}

   function valueToSec($value, $row)
{
    return $value.' Sec';
}

   function add_so()

   {
     if($this->session->userdata('logged_in')){
     $session_data = $this->session->userdata('logged_in');
     $data['username'] = $session_data['username'];
	 $data['email'] = $session_data['email'];
	 $data['first_name'] = $session_data['first_name'];
	 $data['last_name'] = $session_data['last_name'];
	$crud = new grocery_CRUD();
	$crud->set_theme('flexigrid');
    $crud->set_table('service_order');

	$output = $crud->render();
  	$this->load->view('partial/header',$data);
	$this->load->view('add_service_order', $output);
  }else{redirect('login', 'refresh');}

   }


}

?>
