<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
session_start(); //we need to call PHP's session object to access it through CI
class Did extends CI_Controller {

 

function index(){
	redirect('did/create', 'refresh');
}


function create(){

	if ($this->input->post()) {
    $post_data = $this->input->post();
    //print_r($post_data);
    $did_number = $this->input->post('did_number');
    $firstname = $this->input->post('firstname');
    $lastname = $this->input->post('lastname');
    $phone = $this->input->post('phone');
    $address = $this->input->post('address');
    $tarrif = $this->input->post('tarrif');
    $initial_balance = $this->input->post('initial_balance');
    $max_concurrent = $this->input->post('max_concurrent');
    
    $db_billing = $this->load->database('billing', TRUE);
    
    // 1. Check if DID number exists in the number_plan table
    $query_did_check = $this->db->query('SELECT COUNT(nu_id) as count FROM number_plan WHERE number = ? LIMIT 1', array($did_number));
    $did_check_result = $query_did_check->row()->count;
    if ($did_check_result == 0) {
        $this->session->set_flashdata('error_message', 'Invalid DID, it should start with 0964 and be 11 digits long.');
        redirect('did/create', 'refresh');
    }
    if (strlen($did_number) != 11 || substr($did_number, 0, 4) !== '0964') {
        $this->session->set_flashdata('error_message', 'Invalid DID, it should start with 0964 and be 11 digits long.');
        redirect('did/create', 'refresh');
    }
    
    // Check if DID number already exists in the cc_callerid table
    $query_callerid_check = $db_billing->query('SELECT cid, id_cc_card FROM cc_callerid WHERE cid = ?', array($did_number));
    $results_callerid_check = $query_callerid_check->result_array();

   if (count($results_callerid_check) > 0) {
        $this->session->set_flashdata('error_message', 'DID Already exists');
        redirect('did/create', 'refresh');
    } else {

        $least_id = $db_billing->query('SELECT MAX(id) as least_id FROM cc_card')->row()->least_id;
        $new_cc_card_id = $least_id + 1;

        // Generate a unique account code
        function generate_unique_accountcode($db_billing) {
            do {
                $length = rand(6, 15);  // Randomly choose the length between 6 and 15 digits
                $accountcode = str_pad(rand(0, pow(10, $length) - 1), $length, '0', STR_PAD_LEFT);
                $query = $db_billing->query("SELECT COUNT(id) AS count FROM cc_card WHERE username = ?", array($accountcode));
                $result = $query->row();
            } while ($result->count > 0); 
            return $accountcode;
        }

        $accountcode = generate_unique_accountcode($db_billing);
        $uipass = bin2hex(random_bytes(8));
        $useralias = $accountcode;

        // insertion into cc_card table
        $data = array(
            'id' => $new_cc_card_id,
            'tariff' => $tarrif,
            'lastname' => $lastname,
            'firstname' => $firstname,
            'address' => $address,
            'phone' => $phone,
            'max_concurrent' => $max_concurrent,
            'credit' => $initial_balance,
            'username' => $accountcode,
            'useralias' => $useralias,
            'uipass' => $uipass
        );
        
        // Insert into cc_card table
        $insert_cc_card = $db_billing->insert('cc_card', $data);

        // Insert into cc_callerid table
        $cc_callerid_data = array(
            'cid' => $did_number,
            'id_cc_card' => $new_cc_card_id
        );
        $insert_cc_callerid = $db_billing->insert('cc_callerid', $cc_callerid_data);



        //////////////////Insert into cc_did
		$id_cc_did = $db_billing->query('SELECT id as id_cc_did FROM cc_card order by id desc limit 1')->row()->id_cc_did;
        $id_cc_did_new = $id_cc_did + 1;
		
		$session_data = $this->session->userdata('logged_in');
		$cc_did_data = array(
            'id_cc_didgroup' => '2',
            'id_cc_country' => '18',
            'activated' => '1',
            'reserved' => '1',
            'iduser' => $new_cc_card_id,
            'did' => $did_number,
            'startingdate' => $max_concurrent,
            'expirationdate' => $initial_balance,
            'description' => $session_data['username'],
            'secondusedreal' => '0',
            'billingtype' => '3',
            'fixrate' => '0',
            'connection_charge' => '0',
            'selling_rate' => '0',
            'aleg_carrier_connect_charge' => '0',
            'aleg_carrier_cost_min' => '0',
            'aleg_retail_connect_charge' => '0'
        );
		  $insert_cc_did_data = $db_billing->insert('cc_did', $cc_did_data);
		
		//$id_cc_did = $db_billing->query('SELECT id as id_cc_did FROM cc_card order by id desc limit 1')->row()->id_cc_did;
		
		$id_cc_did = $db_billing->query('SELECT id as id_cc_did FROM cc_did WHERE did = ?', [$did_number])->row()->id_cc_did;

        //$new_cc_card_id = $least_id + 1;
		
		/////////////////Insert into cc_did_destination
		$destination = "SIP/"."$did_number";
		$cc_did_destination_data = array(
		   'destination' => $destination,
		   'priority' => '1',
		   'id_cc_card' => $new_cc_card_id,
		   'id_cc_did' => $id_cc_did, ///////////
		   'activated' => '1',
		   'secondusedreal' => '0',
		   'voip_call' => '1',
		   'validated' => '1'
			
		);
		
		$insert_cc_did_destination_data = $db_billing->insert('cc_did_destination', $cc_did_destination_data);
		

        // Check if both insertions were successful
        if ($insert_cc_card && $insert_cc_callerid) {
            // Update the number_plan table
			$fullname = trim($firstname . ' ' . $lastname);
			if (empty($fullname)) {
				$fullname = ' '; 
			}
            $update_data = array(
                'service_order' => $accountcode,
                'customer' => $fullname,
                'status' => 'assigned'
            );
			
            $this->db->where('number', $did_number);
            $update_success = $this->db->update('number_plan', $update_data);
            if ($update_success) {
                $this->session->set_flashdata('success_message', "DID $did_number successfully created and the account code is: $accountcode");
                redirect('did/create', 'refresh');
            } else {
                $this->session->set_flashdata('error_message', 'Failed to update number_plan ');
                redirect('did/create', 'refresh');
            }
        } else {
            $this->session->set_flashdata('error_message', 'Failed to insert data into cc_card or cc_callerid');
            redirect('did/create', 'refresh');
        }
    }
}


	else{
	// echo "amir";
	$db_billing = $this->load->database('billing', TRUE);
	$query1 = $db_billing->query('SELECT * FROM cc_tariffgroup');	   
	$results = $query1->result_array(); 	
    if($this->session->userdata('logged_in')){
    $session_data = $this->session->userdata('logged_in');
    $data['username'] = $session_data['username'];
    $data['email'] = $session_data['email'];
    $data['first_name'] = $session_data['first_name'];
    $data['last_name'] = $session_data['last_name'];
    $data['pic'] = $session_data['pic'];
    $data['tarrifs'] = $results;
    $crud = new grocery_CRUD();
    $crud->set_theme('flexigrid');
    $crud->set_table('credits');
	$crud->order_by('rechargetime', 'desc');
    $crud->unset_add();
    $crud->unset_edit();
    $crud->unset_delete();
    $output = $crud->render();
    $this->load->view('partial/header',$data);
    $this->load->view('did_create', $output);
    }else{redirect('login', 'refresh');}
}
   
}



function did_route() {
    $this->load->library('session');

    if (!$this->session->userdata('logged_in')) {
        redirect('login', 'refresh');
        return; 
    }

    $session_data = $this->session->userdata('logged_in');
    $data['username'] = $session_data['username'];
    $data['email'] = $session_data['email'];
    $data['first_name'] = $session_data['first_name'];
    $data['last_name'] = $session_data['last_name'];
    $data['pic'] = $session_data['pic'];

    $db_billing = $this->load->database('billing', TRUE);

    $data['sub_accounts'] = $this->mViewData['sub_accounts'] = $this->db->query("
        SELECT number, service_order as account_code 
        FROM number_plan 
        WHERE status = 'assigned' 
        AND (service_order IS NOT NULL AND service_order != '')
    ")->result();
	

    if ($this->input->post()) {

        $did = $this->input->post('account_label');
        $did_destination = $this->input->post('did_destination');
        $did_destination = "SIP/"."$did_destination";


        $id_cc_did_query = $db_billing->query("SELECT id FROM cc_did WHERE did = ? LIMIT 1", [$did]);
        $id_cc_did = $id_cc_did_query->row()->id ?? null;


        if ($did && $did_destination && $id_cc_did) {
 
            $update_data = [
                'destination' => $did_destination,
            ];


            $db_billing->where('id_cc_did', $id_cc_did);
            $update_result = $db_billing->update('cc_did_destination', $update_data);

         
            if ($update_result) {
                $this->session->set_flashdata('success_message', 'DID Routing updated successfully.');
            } else {
                $this->session->set_flashdata('error_message', 'Failed to update DID Routing. Please try again.');
            }
        } else {
     
            $this->session->set_flashdata('error_message', 'Invalid input or DID not found. Please try again.');
        }

  
        redirect('did/did_route', 'refresh');
    } else {
    
        $data['did_destinations'] = [];

        foreach ($data['sub_accounts'] as $sub_account) {
            $did = $sub_account->number;

       
            $id_cc_did_query = $db_billing->query("SELECT id FROM cc_did WHERE did = ?", [$did]);
            $id_cc_did = $id_cc_did_query->row()->id ?? null;

            if ($id_cc_did) {
         
                $did_destination_query = $db_billing->query("SELECT destination AS did_destination FROM cc_did_destination WHERE id_cc_did = ?", [$id_cc_did]);
                $did_destination = $did_destination_query->row()->did_destination ?? null;
				$data['did_destinations'][$did] = substr($did_destination, 4);
                //$data['did_destinations'][$did] = $did_destination;
                
            }
        }


       
        $this->load->view('partial/header', $data);
        $this->load->view('did_route');
    }
}

}

?>
