<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
session_start(); //we need to call PHP's session object to access it through CI
class Call_logs extends CI_Controller {

 function __construct()
 {
   parent::__construct();

 }
 
 public function index()
{
    if ($this->session->userdata('logged_in')) {
        // Fetch session data
        $session_data = $this->session->userdata('logged_in');
        $data['username'] = $session_data['username'];
        $data['email'] = $session_data['email'];
        $data['first_name'] = $session_data['first_name'];
        $data['last_name'] = $session_data['last_name'];
        $data['pic'] = $session_data['pic'];
        $id_client = '10'; 
        $did = $this->input->post('did');
        $call_start_date = $this->input->post('datefilter1');
        $call_end_date = $this->input->post('datefilter2');

        // Format the date range for the SQL query
        // // $start_time_add = $call_start_date . ' 00:00:00';
        // // $call_start_str = strtotime($start_time_add);
        // // $call_start = date('Y-m-d H:i:s', $call_start_str);

        // // $end_time_add = $call_end_date . ' 23:59:59';
        // // $call_end_str = strtotime($end_time_add);
        // // $call_end = date('Y-m-d H:i:s', $call_end_str);

        // // // Validate the date range
        // // if ($call_start_date > $call_end_date) {
            // // echo 'End Date should be greater/equal to Start Date';
        // // } else {
            // // // Query for call logs
            // // $sql = $this->db->query("SELECT call_start, call_end, caller_id, called_number, effective_duration, cost FROM calls WHERE id_client IN ($id_client) AND call_start >= CAST('$call_start' AS DATETIME) AND call_end <= CAST('$call_end' AS DATETIME)");

            // // // Store the result in 'h' for call logs (if needed)
            // // $data['h'] = $sql->result();
        // // }

        // Grocery CRUD Section
        $crud = new grocery_CRUD();
        $crud->set_theme('flexigrid');
        $crud->set_table('cu_technical');
        $crud->set_relation_n_n('client_name', 'ci_cn', 'customers', 'ct_id', 'cu_id', 'name');
        $crud->set_relation_n_n('device', 'ci_de', 'devices', 'ct_id', 'de_id', 'device');
        $crud->set_field_upload('visio_diagram', 'assets/uploads/files');
        $output = $crud->render();

        // Load the header view
        $this->load->view('partial/header', $data);

        // Load the call logs and CRUD view
        $this->load->view('call_logs_view', $data);
      //  $this->load->view('partial/footer'); // Ensure you load the footer as well (if needed)
    } else {
        redirect('login', 'refresh');
    }
}

 
public function fetch_call_logs()
{
    header('Content-Type: application/json');

    if ($this->input->is_ajax_request()) {
        $billingDb = $this->load->database('billing', TRUE);

        $fromNumber = $this->input->post('fromNumber');
        $toNumber = $this->input->post('toNumber');
        $accountCode = $this->input->post('accountCode');
        $startDatetime = str_replace('T', ' ', $this->input->post('startDatetime'));
		
        $endDatetime = str_replace('T', ' ', $this->input->post('endDatetime'));
		
		
		$billingDb->query("SET optimizer_switch='index_merge=on'");

$billingDb->select("
    cc_call.src, 
    cc_call.dnid AS calledstation, 
    cc_call.starttime,
    cc_call.a2b_custom1 AS call_direction, 
    cc_call.terminatecauseid,
    cc_call.stoptime, 
    cc_call.sessiontime AS duration, 
    cc_call.sessionbill AS call_cost, 
    cc_card.username AS accountcode
");

// Use indexed column filtering efficiently
$billingDb->from('cc_call USE INDEX (idx_cardid_starttime_stoptime)');
$billingDb->join('cc_card', 'cc_call.card_id = cc_card.id', 'LEFT');

// Filter only non-empty dnid values
$billingDb->where("cc_call.dnid IS NOT NULL AND cc_call.dnid != ''");

if (!empty($fromNumber)) {
    $billingDb->where("cc_call.src", $fromNumber);
}

if (!empty($toNumber)) {
    $billingDb->where("cc_call.dnid", $toNumber);
}

if (!empty($accountCode)) {
    $billingDb->join('cc_card AS filter_card', 'cc_call.card_id = filter_card.id', 'INNER');
    $billingDb->where("filter_card.username", $accountCode);
}

// Ensure valid time range for filtering
$startDatetime = !empty($startDatetime) ? $startDatetime : date('Y-m-d') . ' 00:00:01';
$billingDb->where("cc_call.starttime BETWEEN '$startDatetime' AND '$endDatetime'");

$query = $billingDb->get();
$result = $query->result_array();

echo json_encode(["data" => $result], JSON_PRETTY_PRINT);
exit;

		
		
		// $billingDb->query("SET optimizer_switch='index_merge=on'");
        // $billingDb->select('cc_call.src, cc_call.dnid as calledstation, cc_call.starttime,cc_call.a2b_custom1 as call_direction, cc_call.terminatecauseid,cc_call.stoptime, cc_call.sessiontime AS duration, cc_call.sessionbill AS call_cost, cc_card.username AS accountcode');
        // $billingDb->where('dnid !=', ' ');
        // $billingDb->from('cc_call');
        // $billingDb->join('cc_card', 'cc_call.card_id = cc_card.id', 'left');

        // if (!empty($fromNumber)) {
            // $billingDb->where("src", $fromNumber);
        // }

        // if (!empty($toNumber)) {
            // $billingDb->where("dnid", $toNumber);
        // }

        // if (!empty($accountCode)) {
            // $cardQuery = $billingDb->query("SELECT id AS card_id FROM cc_card WHERE username = ? LIMIT 1", [$accountCode]);
            // $cardResult = $cardQuery->row_array();
            // if (!empty($cardResult['card_id'])) {
                // $billingDb->where("card_id", $cardResult['card_id']);
            // } else {
                // echo json_encode(["data" => []]);
                // exit;
            // }
        // }

     
		// if (empty($startDatetime)) {
			// $startDatetime = date('Y-m-d') . ' 00:00:01';
		// }else{
			   // $billingDb->where("starttime >=", $startDatetime);
		// }
				
        // $billingDb->where("stoptime <=", $endDatetime);

        // $query = $billingDb->get();
        // $result = $query->result_array();

 
        // echo json_encode(["data" => $result], JSON_PRETTY_PRINT);
        // exit;
    } else {
        echo json_encode(["error" => "Invalid request"]);
        exit;
    }
}

 // public function export_csv() {
    // $this->load->dbutil();
    // $this->load->helper('file');
    // $this->load->helper('download');

    // // Load the secondary database
    // $billingDb = $this->load->database('billing', TRUE);

    // $fromNumber = $this->input->get('fromNumber');
    // $toNumber = $this->input->get('toNumber');
    // $accountCode = $this->input->get('accountCode');
    // $startDatetime = $this->input->get('startDatetime');
    // $endDatetime = $this->input->get('endDatetime');

    // // Build query based on the filters
    // $billingDb->select('src, dnid as calledstation, starttime, a2b_custom1 as call_direction, terminatecauseid, stoptime, sessiontime as duration, sessionbill as call_cost, username as accountcode');
    // $billingDb->from('cc_call');
    // $billingDb->join('cc_card', 'cc_call.card_id = cc_card.id', 'left');
    // $billingDb->where('dnid !=', ' ');

    // if (!empty($fromNumber)) {
        // $billingDb->where('src', $fromNumber);
    // }
    // if (!empty($toNumber)) {
        // $billingDb->where('dnid', $toNumber);
    // }
    // if (!empty($accountCode)) {
        // $billingDb->where('username', $accountCode);
    // }
    // if (!empty($startDatetime)) {
        // $billingDb->where('starttime >=', $startDatetime);
    // }
    // if (!empty($endDatetime)) {
        // $billingDb->where('stoptime <=', $endDatetime);
    // }

    // $query = $billingDb->get();

    // // Convert query result to CSV
    // $csv_data = $this->dbutil->csv_from_result($query);
    // $filename = 'red_data_cdr_' . date('Y_m_d_H_i_s') . '.csv';

    // // Force download
    // force_download($filename, $csv_data);
// }


// public function export_excel() {
    // $this->load->dbutil();
    // $this->load->helper('file');
    // $this->load->helper('download');

    // // Load the secondary database
    // $billingDb = $this->load->database('billing', TRUE);

    // $fromNumber = $this->input->get('fromNumber');
    // $toNumber = $this->input->get('toNumber');
    // $accountCode = $this->input->get('accountCode');
    // $startDatetime = $this->input->get('startDatetime');
    // $endDatetime = $this->input->get('endDatetime');

    // // Build query based on the filters
    // $billingDb->select('src, dnid as calledstation, starttime, a2b_custom1 as call_direction, terminatecauseid, stoptime, sessiontime as duration, sessionbill as call_cost, username as accountcode');
    // $billingDb->from('cc_call');
    // $billingDb->join('cc_card', 'cc_call.card_id = cc_card.id', 'left');
    // $billingDb->where('dnid !=', ' ');

    // if (!empty($fromNumber)) {
        // $billingDb->where('src', $fromNumber);
    // }
    // if (!empty($toNumber)) {
        // $billingDb->where('dnid', $toNumber);
    // }
    // if (!empty($accountCode)) {
        // $billingDb->where('username', $accountCode);
    // }
    // if (!empty($startDatetime)) {
        // $billingDb->where('starttime >=', $startDatetime);
    // }
    // if (!empty($endDatetime)) {
        // $billingDb->where('stoptime <=', $endDatetime);
    // }

    // $query = $billingDb->get();

    // // Convert query result to CSV (Excel uses CSV format)
    // $excel_data = $this->dbutil->csv_from_result($query);
    // $filename = 'red_data_cdr_' . date('Y_m_d_H_i_s') . '.xls';

    // // Force download for Excel
    // force_download($filename, $excel_data);
// }

// public function print_data() {
    // // Load the secondary database
    // $billingDb = $this->load->database('billing', TRUE);

    // $fromNumber = $this->input->get('fromNumber');
    // $toNumber = $this->input->get('toNumber');
    // $accountCode = $this->input->get('accountCode');
    // $startDatetime = $this->input->get('startDatetime');
    // $endDatetime = $this->input->get('endDatetime');

    // // Build query based on the filters
    // $billingDb->select('src, dnid as calledstation, starttime, a2b_custom1 as call_direction, terminatecauseid, stoptime, sessiontime as duration, sessionbill as call_cost, username as accountcode');
    // $billingDb->from('cc_call');
    // $billingDb->join('cc_card', 'cc_call.card_id = cc_card.id', 'left');
    // $billingDb->where('dnid !=', ' ');

    // if (!empty($fromNumber)) {
        // $billingDb->where('src', $fromNumber);
    // }
    // if (!empty($toNumber)) {
        // $billingDb->where('dnid', $toNumber);
    // }
    // if (!empty($accountCode)) {
        // $billingDb->where('username', $accountCode);
    // }
    // if (!empty($startDatetime)) {
        // $billingDb->where('starttime >=', $startDatetime);
    // }
    // if (!empty($endDatetime)) {
        // $billingDb->where('stoptime <=', $endDatetime);
    // }

    // $query = $billingDb->get();

    // // Pass the data to view for printing
    // $data['call_logs'] = $query->result();
    // $this->load->view('call_logs/print_view', $data);
// }

private function get_filtered_call_logs() {
    $billingDb = $this->load->database('billing', TRUE);
    $fromNumber = $this->input->get('fromNumber');
    $toNumber = $this->input->get('toNumber');
    $accountCode = $this->input->get('accountCode');
    $startDatetime = $this->input->get('startDatetime') ?: date('Y-m-d') . ' 00:00:01';
    $endDatetime = $this->input->get('endDatetime');

    $billingDb->query("SET optimizer_switch='index_merge=on'");
    $billingDb->select('cc_call.src, cc_call.dnid AS calledstation, cc_call.starttime, cc_call.a2b_custom1 AS call_direction, cc_call.terminatecauseid, cc_call.stoptime, cc_call.sessiontime AS duration, cc_call.sessionbill AS call_cost, cc_card.username AS accountcode');
    $billingDb->from('cc_call USE INDEX (idx_cardid_starttime_stoptime)');
    $billingDb->join('cc_card', 'cc_call.card_id = cc_card.id', 'left');
    $billingDb->where('cc_call.dnid !=', '');

    if (!empty($fromNumber)) {
        $billingDb->where('cc_call.src', $fromNumber);
    }
    if (!empty($toNumber)) {
        $billingDb->where('cc_call.dnid', $toNumber);
    }
    if (!empty($accountCode)) {
        $cardQuery = $billingDb->query("SELECT id FROM cc_card WHERE username = ? LIMIT 1", [$accountCode]);
        $cardResult = $cardQuery->row_array();
        if (!empty($cardResult['id'])) {
            $billingDb->where('cc_call.card_id', $cardResult['id']);
        } else {
            return false;
        }
    }
    
    $billingDb->where('cc_call.starttime >=', $startDatetime);
    if (!empty($endDatetime)) {
        $billingDb->where('cc_call.stoptime <=', $endDatetime);
    }

    return $billingDb->get();
}

public function export_csv() {
    $this->load->dbutil();
    $this->load->helper(['file', 'download']);

    $query = $this->get_filtered_call_logs();
    if (!$query || $query->num_rows() === 0) {
        show_error('No data available for export.');
        return;
    }

    $csv_data = $this->dbutil->csv_from_result($query);
    $filename = 'call_logs_' . date('Y_m_d_H_i_s') . '.csv';
    force_download($filename, $csv_data);
}

public function export_excel() {
    $this->load->dbutil();
    $this->load->helper(['file', 'download']);

    $query = $this->get_filtered_call_logs();
    if (!$query || $query->num_rows() === 0) {
        show_error('No data available for export.');
        return;
    }

    $excel_data = $this->dbutil->csv_from_result($query);
    $filename = 'call_logs_' . date('Y_m_d_H_i_s') . '.csv'; // Excel-compatible CSV
    force_download($filename, $excel_data);
}

public function print_data() {
    $query = $this->get_filtered_call_logs();
    if (!$query || $query->num_rows() === 0) {
        show_error('No data available for printing.');
        return;
    }

    $data['call_logs'] = $query->result();
    $this->load->view('call_logs/print_view', $data);
}

  // public function export()
 // {
	 // $data_csv = $this->index();
	 
	 // print_r($data_csv);
	 
	 // print_r($data ['h']);
		  
	// $file_name = 'CDR-'.date('Ymd').'.csv'; 
     // header("Content-Description: File Transfer"); 
     // header("Content-Disposition: attachment; filename=$file_name"); 
     // header("Content-Type: application/csv;");
   
     // // get data 
     // //$student_data = $this->export_csv_model->fetch_data();
	 
	 

     // // file creation 
     // $file = fopen('php://output', 'w');
 
     // $header = array("call_start","call_end","caller_id","called_number","effective_duration","cost"); 
     // fputcsv($file, $header);
	 
	 // foreach ($h as $row)  
					 // { 
					 // echo "<tr>
         // <td>$row->call_start</td>
         // <td>$row->call_end</td>
		 // <td>$row->caller_id</td>
		 // <td>$row->caller_id</td>
		 // <td>$row->called_number</td>
		 // <td>$row->effective_duration</td>
		 // <td>$row->cost</td></tr>";
					 // fputcsv($file, $row); 
					 // }
					 
     // // foreach ($student_data->result_array() as $key => $value)
     // // { 
       // // fputcsv($file, $value); 
     // // }
     // fclose($file); 
     // exit; 
 // }


}

?>
