<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Testimonial extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('testimonial_model');
    }

    // home slider
    public function index()
    {
        // check access permission
        if (!get_permission('frontend_testimonial', 'is_view')) {
            access_denied();
        }
        if ($_POST) {
            if (!get_permission('frontend_testimonial', 'is_add')) {
                access_denied();
            }
            $this->slider_validation();
            if ($this->form_validation->run() == false) {
                $this->data['validation_error'] = true;
            } else {
                // save information in the database
                $data = $this->input->post();
                $this->testimonial_model->save($data);
                set_alert('success', translate('information_has_been_saved_successfully'));
                redirect(base_url('frontend/testimonial'));
            }
        }

        $this->data['testimoniallist'] = $this->testimonial_model->get_list('front_cms_testimonial');
        $this->data['title'] = translate('frontend');
        $this->data['sub_page'] = 'frontend/testimonial';
        $this->data['main_menu'] = 'frontend';
        $this->load->view('layout/index', $this->data);
    }

    // home slider edit
    public function edit($id = '')
    {
        if (!get_permission('frontend_testimonial', 'is_edit')) {
            access_denied();
        }
        if ($_POST) {
            $this->slider_validation();
            if ($this->form_validation->run() == false) {
                $this->data['validation_error'] = true;
            } else {
                // update information in the database
                $data = $this->input->post();
                $this->testimonial_model->save($data);
                set_alert('success', translate('information_has_been_updated_successfully'));
                redirect(base_url('frontend/testimonial'));
            }
        }

        $this->data['testimonial'] = $this->testimonial_model->get_list('front_cms_testimonial', array('id' => $id), true);
        $this->data['title'] = translate('frontend');
        $this->data['sub_page'] = 'frontend/testimonial_edit';
        $this->data['main_menu'] = 'frontend';
        $this->load->view('layout/index', $this->data);
    }

    // home slider delete
    public function delete($id = '')
    {
        if (!get_permission('frontend_testimonial', 'is_delete')) {
            access_denied();
        }
        $image = $this->db->get_where('front_cms_testimonial', array('id' => $id))->row()->image;
        if ($this->db->where(array('id' => $id))->delete("front_cms_testimonial")) {
            // delete testimonial user image
            $destination = './uploads/images/testimonial/';
            if (file_exists($destination . $image)) {
                @unlink($destination . $image);
            }
        }
    }

    private function slider_validation()
    {
        $this->form_validation->set_rules('patient_name', 'Patient Name', 'trim|required|xss_clean');
        $this->form_validation->set_rules('surname', 'Surname', 'trim|required|xss_clean');
        $this->form_validation->set_rules('description', 'Description', 'trim|required|xss_clean');
        $this->form_validation->set_rules('rank', 'Rank', 'trim|required|xss_clean');
        $this->form_validation->set_rules('photo', 'Photo', 'trim|xss_clean|callback_check_image');
    }

    public function check_image()
    {
        if ($this->input->post('testimonial_id')) {
            if (!empty($_FILES['photo']['name'])) {
                $name = $_FILES['photo']['name'];
                $arr = explode('.', $name);
                $ext = end($arr);
                if ($ext == 'jpg' || $ext == 'jpeg' || $ext == 'png') {
                    return true;
                } else {
                    $this->form_validation->set_message('check_image', translate('select_valid_file_format'));
                    return false;
                }
            }
        } else {
            if (isset($_FILES['photo']['name']) && !empty($_FILES['photo']['name'])) {
                $name = $_FILES['photo']['name'];
                $arr = explode('.', $name);
                $ext = end($arr);
                if ($ext == 'jpg' || $ext == 'jpeg' || $ext == 'png') {
                    return true;
                } else {
                    $this->form_validation->set_message('check_image', translate('select_valid_file_format'));
                    return false;
                }
            } else {
                $this->form_validation->set_message('check_image', 'The Photo is required.');
                return false;
            }
        }
    }
}
